/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.http;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.filesystem.http.HttpFilesystemPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class HttpFileStore
extends FileStore {
    private URI uri;

    HttpFileStore(URI uri) {
        this.uri = uri;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return new String[0];
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo result = new FileInfo(this.getName());
        try {
            HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection();
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setDoOutput(false);
            connection.setRequestMethod("HEAD");
            int length = connection.getContentLength();
            long lastModified = connection.getLastModified();
            result.setExists(true);
            result.setLastModified(lastModified);
            if (length == -1) {
                result.setLength(0L);
            } else {
                result.setLength((long)length);
            }
        }
        catch (IOException e) {
            HttpFilesystemPlugin.log(e);
            result.setExists(false);
        }
        return result;
    }

    public IFileStore getChild(String name) {
        return new HttpFileStore(this.uri.resolve(name));
    }

    public String getName() {
        return this.uri.toString();
    }

    public IFileStore getParent() {
        try {
            String path = this.uri.getPath();
            Path aPath = new Path(path);
            aPath = aPath.removeLastSegments(1);
            URI parentURI = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), aPath.toPortableString(), this.uri.getQuery(), this.uri.getFragment());
            return new HttpFileStore(parentURI);
        }
        catch (URISyntaxException e) {
            HttpFilesystemPlugin.log(e);
            return null;
        }
    }

    public URI toURI() {
        return this.uri;
    }

    public synchronized File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        long remoteLastModified;
        IFileStore localFile;
        long lastModified;
        if ((options & 0x1000) == 0) {
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        File tmpDir = FileUtil.getTempDirectory().toFile();
        File cached = new File(tmpDir, HttpFileStore.getPath(this.uri));
        if (cached.exists() && (lastModified = (localFile = EFS.getLocalFileSystem().fromLocalFile(cached)).fetchInfo(0, (IProgressMonitor)sub.newChild(5)).getLastModified()) >= (remoteLastModified = this.fetchInfo(0, (IProgressMonitor)sub.newChild(20)).getLastModified())) {
            if (IdeLog.isTraceEnabled((Plugin)HttpFilesystemPlugin.getDefault(), (String)"com.aptana.filesystem.http/debug/filesystem")) {
                IdeLog.logTrace((Plugin)HttpFilesystemPlugin.getDefault(), (String)MessageFormat.format("Returning locally cached URI {0} version for remote URI {0}", localFile.toURI(), this.uri));
            }
            return cached;
        }
        sub.worked(25);
        if (!cached.getParentFile().exists() && !cached.getParentFile().mkdirs()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.http", 566, MessageFormat.format("Unable to create directory structure {0} for locally cached copy", cached.getParentFile()), null));
        }
        IFileStore resultStore = EFS.getLocalFileSystem().fromLocalFile(cached);
        this.copy(resultStore, 2, (IProgressMonitor)sub.newChild(75));
        cached.deleteOnExit();
        if (IdeLog.isTraceEnabled((Plugin)HttpFilesystemPlugin.getDefault(), (String)"com.aptana.filesystem.http/debug/filesystem")) {
            IdeLog.logTrace((Plugin)HttpFilesystemPlugin.getDefault(), (String)MessageFormat.format("Caching remote URI {0} to local URI {1}", this.uri, resultStore.toURI()));
        }
        return cached;
    }

    public static String getPath(URI uri) {
        char separator = '_';
        StringBuilder builder = new StringBuilder();
        builder.append(uri.getScheme());
        builder.append(separator);
        builder.append(uri.getHost());
        builder.append(separator);
        int port = uri.getPort();
        int defaultPort = 80;
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            defaultPort = 443;
        }
        if (port != -1 && port != defaultPort) {
            builder.append(uri.getPort());
            builder.append(separator);
        }
        builder.append(separator);
        builder.append(builder.hashCode());
        builder.append(new Path(uri.getPath().replace('/', separator)).toOSString());
        return builder.toString();
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            monitor.beginTask("", 1);
            InputStream inputStream = this.uri.toURL().openStream();
            return inputStream;
        }
        catch (MalformedURLException e) {
            HttpFilesystemPlugin.log(e);
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.http", 270, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            HttpFilesystemPlugin.log(e);
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.http", 271, e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }
}

